import subprocess
import argparse

def main():
    parser = argparse.ArgumentParser()

    parser.add_argument('--T', type=int, default=5000)
    parser.add_argument('--N', type=int, default=1642) 
    parser.add_argument('--K', type=int, nargs='*', default=[1])
    parser.add_argument('--dim', type=int, default=5)
    parser.add_argument('--lam', type=float, default=1.0)
    parser.add_argument('--seed', type=int, nargs='*', default=range(20))
    parser.add_argument('--alg', nargs='*', default=['UCBCLB', 'UCBCCA', 'CLogUCB', 'C3UCB'])
    parser.add_argument('--oracle', default='optimal') # optimal
    parser.add_argument('--data', default='movie') # movie
    parser.add_argument('--B', type=float, default=20.0)
    parser.add_argument('--C', type=float, default=1.0)

    args = parser.parse_args()
    
    T = args.T
    N = args.N
    Ks = args.K
    dim = args.dim
    lam = args.lam
    seeds = args.seed
    algorithms = args.alg
    oracle_type = args.oracle
    data = args.data
    B = args.B
    C = args.C

    commands = []

    for seed in seeds:
        for k in Ks:
            for alg in algorithms:
                commands.append(f'python experiment-{data}.py --T {T} --N {N} --dim {dim} --lam {lam} --oracle {oracle_type} --alg {alg} --K {k} --seed {seed} --B {B} --C {C}')

    print(len(commands))
    print(commands[0])

    for i, cmd in enumerate(commands, 1):
        print(f"\nProcessing ({i}/{len(commands)}): {cmd}")
        result = subprocess.run(cmd, shell=True)
    
        if result.returncode != 0:
            print(f"Error: {cmd} Fail")


if __name__ == "__main__":

    main()


